package org.msh.tb.bd.tbforms.indicator.tb10;

import org.jboss.seam.Component;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.msh.tb.bd.tbforms.query.TbFormQuery;
import org.msh.tb.bd.tbforms.query.tb10.TBForm10Block2Query;
import org.msh.tb.bd.tbforms.query.tb10.TBForm10Block3Query;
import org.msh.tb.entities.AdministrativeUnit;
import org.msh.tb.entities.FieldValue;
import org.msh.tb.entities.Tbunit;
import org.msh.tb.entities.enums.CaseClassification;
import org.msh.tb.entities.enums.DiagnosisType;
import org.msh.tb.indicators.core.Indicator2D;
import org.msh.tb.misc.FieldsQuery;

import java.util.List;
import java.util.Map;

@Name("TBForm10Block2")
public class TBForm10Block2 extends Indicator2D {

    TbFormQuery formQuery;

    @In(create=true) protected Map<String, String> messages;

    @Override
    protected void createIndicators() {
        includeAllRefByOnInterfaceTable();

        Tbunit tbunit = getIndicatorFilters().getTbunitselection().getSelected();
        AdministrativeUnit adminUnit = getIndicatorFilters().getTbunitselection().getLastLevelAdminUnitSelected();

        List<Object[]> result = getFormQuery().queryDB(tbunit,
                adminUnit,
                getWorkspace(),
                getIndicatorFilters().getQuarter(),
                getEntityManager());

        populateInfacetableRows(result);
    }

    /**
     * Includes the result on the interface table
     * @param result the result of the query used to get the number by patient referred by
     */
    private void populateInfacetableRows(List<Object[]> result){
        for(Object[] r : result){
            String refByName = (String) r[1];
            Long qtd = (Long) r[2];

            addValue(refByName,"nodisplayname_line1", qtd.floatValue());
            addValue(messages.get("global.total"),"nodisplayname_line1", qtd.floatValue());
        }
    }

    /**
     * Initialize the interface table. All referred by types should be there also if it's result is zero.
     */
    private void includeAllRefByOnInterfaceTable(){
        getTable()
                .addCondition("(c.patientType in (0,48) or (c.patientType = 44 and c.previouslyTreatedType in (1,45,46,47)))")
                .addCondition("c.classification = " + CaseClassification.TB.ordinal())
                .addCondition("c.diagnosisType = " + DiagnosisType.CONFIRMED.ordinal())
                .addCondition("c.age is not null")
                .addCondition("p.gender is not null");

        List<FieldValue> refBys = ((FieldsQuery)Component.getInstance(FieldsQuery.class)).getRefToTypes();

        for(FieldValue f : refBys){
            addValue(f.getName().getName1(),"nodisplayname_line1", new Float(0))
                .addCondition("c.patientRefToFv.id = " + f.getId());
        }
    }

    private TbFormQuery getFormQuery() {
        if (formQuery == null) {
            formQuery = new TBForm10Block2Query();
        }

        return formQuery;
    }
}
